create function stats(year_or_quad character varying, rank integer, if_month integer DEFAULT 1)
    returns TABLE(loc_name character varying, count bigint)
    language sql
as
$$
SELECT (if_month*rank || year_or_quad)::interval,
       location_name(c.loca_id) as location_name, count(*) FROM segments s join connections c on s.connection_id = c.id
where accident = false and
        time > current_timestamp - (if_month*rank || year_or_quad)::interval and
        time <= current_timestamp - (if_month*(rank-1) || year_or_quad)::interval
group by c.loca_id order by count(*) desc limit 3
$$;

alter function stats(varchar, integer, integer) owner to "paluch12@uniba.sk";
